import store from 'systems/store.js'
import math  from 'libraries/physics/math.js'



function getClosest (pos, a, b) {
  let aDistance = math.twoPointDistance(pos, a.isoPos)
  let bDistance = math.twoPointDistance(pos, b.isoPos)

  return aDistance < bDistance ? a : b

}


function getClosestZone ({ graphData }, pos) {
  return graphData.zones.reduce((closest, zone) => getClosest(pos, zone, closest))
}



function getClosestLinkedZone ({ graphData }, pos) {
  return graphData.zones.reduce((closest, zone) => {
    if (!zone.links.length) {
      return closest
    }

    return getClosest(pos, zone, closest)
  })
}



export default {
  id: 'pathLib',
  dependencies: ['graphDataBuilder'],
  storeDependencies: ['graphData'],
  tags: ['pathFinder'],
  receiver: (b) => b({
    getClosestLinkedZone: store.makeDependentTo(['graphData'], getClosestLinkedZone),
    getClosestZone:       store.makeDependentTo(['graphData'], getClosestZone)
  })
}